/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Last Modification:

    @version $Id: EtherCATMaster_AP_Functionlist.h 19755 2011-10-05 17:38:22Z Ulli $

   Description:

    -Task function list for configuration file

   Changes:

     Date        Author        Description
     ----------------------------------------------------------------------------------
     2011-10-05  UJ            cleanup
     2007-11-02  UJ            created

**************************************************************************************/

#ifndef __ETHERCAT_MASTER_AP_FUNCTIONLIST_H
#define __ETHERCAT_MASTER_AP_FUNCTIONLIST_H

#ifdef __cplusplus
extern "C"
{
#endif

  /*************************************************************************************/
  /** @name Prototypes
   *
   * The following prototypes are declared to represent
   * - the entry point of task
   * @{
   */

  TLR_VOID
  TaskEnter_EtherCATMaster_AP
  (
    TLR_VOID *pvInit
  );

  /** @} */


  /*************************************************************************************/
  /** @name Task Version
   *
   * Subsequently the version of task is defined.
   */

  /** version of task startup parameter */
#define ETHERCAT_MASTER_AP_STARTUP_PARAM_VERSION (1)


  /*************************************************************************************/
  /** @name Startup Parameter
   *
   * The following definition represent the task startup parameter.
   * @{
   */

  /** task startup parameter */
  typedef struct ETHERCAT_MASTER_AP_STARTUPPARAMETER_Ttag  ETHERCAT_MASTER_AP_STARTUPPARAMETER_T;


  /** task startup parameter
   *
   * The structure represent a set of the startup parameter, which can be defined
   * or have to be defined to configure the task.
   */
  struct ETHERCAT_MASTER_AP_STARTUPPARAMETER_Ttag    /* task startup parameter */
  {
    TLR_TASK_PARAMETERHEADER;

    /** A dummy */
    TLR_UINT32  ulDummy;
  };

  /** @} */

#ifdef __cplusplus
}
#endif

/*************************************************************************************/
#endif /* #ifndef __ETHERCAT_MASTER_AP_FUNCTIONLIST_H */
